#include <Servo.h>   // includes library for access to servo controls

Servo myservo;  // create servo object to control a servo
int pos = 0;    // variable to store the servo position

void setup() {
  myservo.attach(8);  // attaches the servo on pin 8 to the servo object
  myservo.write(0);   // starts servo position at 0 degrees
}


void loop() {

  delay(10000); //delay for 10 seconds (10seconds*1000milliseconds)

  for (pos = 0; pos <= 180; pos += 1) { // goes from 0 degrees to 180 degrees (counterclockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(15);                       // waits 15ms for the servo to reach the position
  }
  
}
