#include <Servo.h>   // includes library for access to servo controls

Servo myservo;  // create servo object to control a servo
int pos = 0;    // variable to store the servo position

void setup() {
  myservo.attach(8);  // attaches the servo on pin 8 to the servo object
  myservo.write(0);   // starts servo position at 0 degrees
}

void Shake() {
  
  for (pos = 90; pos <= 120; pos += 1) { // goes from 0 degrees to 90 degrees (counterclockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(5);                       // waits 5ms for the servo to reach the position (quick shake)
  }

  for (pos = 120; pos >= 60; pos -= 1) { // goes from 120 degrees to 60 degrees (clockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(5);                       // waits 5ms for the servo to reach the position (quick shake)
  }

  for (pos = 60; pos <= 120; pos += 1) { // goes from 60 degrees to 120 degrees (counterclockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(5);                       // waits 5ms for the servo to reach the position (quick shake)
  }

  for (pos = 120; pos >= 90; pos -= 1) { // goes from 120 degrees to 90 degrees (clockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(5);                       // waits 5ms for the servo to reach the position (quick shake)
  }
}

void loop() {

  delay(86400000); //delay for 24 hours (24hours*60mins*60seconds*1000milliseconds)

  for (pos = 0; pos <= 90; pos += 1) { // goes from 0 degrees to 90 degrees (counterclockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(15);                       // waits 15ms for the servo to reach the position
  }

  Shake();

  for (pos = 90; pos >= 0; pos -= 1) { // goes from 90 degrees to 0 degrees (clockwise)
    // in steps of 1 degree
    myservo.write(pos);              // tell servo to go to position in variable 'pos'
    delay(15);                       // waits 5ms for the servo to reach the position
  }
}
